clear
run AttyFee2007Definitions.do

log using 03Total_Log.smcl, replace

/// Correlation table of all variables in Tables 3.1 and 3.3
pwcorr lnfeeexpord lnroles lnassets lnemployees lnsales prepack preneg lndaysin xyearfiled yearconfirmed  shop saleall, star(.01) b 

/// Prediction Analysis
/// Table 3.1
reg lnfeeexpord lnassets [pw=pweight], vce(robust)
outreg2 using table3_1.rtf, replace /// 
	label ctitle("FeeExpOrd","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) ///
	title("Table 3.1","Predictors of Aggregate Fees and Expenses")   
outreg2, append: reg  lnfeeexpord lnassets prepack preneg [pw=pweight], vce(robust)
outreg2, append: reg  lnfeeexpord lnassets prepack preneg lnsales  [pw=pweight], vce(robust)
outreg2, append: reg  lnfeeexpord lnassets prepack preneg lnsales xyearfiled shop [pw=pweight], vce(robust)

///  Prediction negative results
/// Chow tests whether industry, judges, or firms as a group have any explanatory power
foreach x in indu judges attyfirms fafirms {
	reg lnfeeexpord lnassets prepack preneg lnemployees xyearfiled shop lnsales $`x'  [pw=pweight], vce(robust)	
	test $`x'
	}
/// Test whether Refiled cases are more or less expensive
reg  lnfeeexpord lnassets prepack preneg lnsales xyearfiled  shop refile [pw=pweight], vce(robust)
/// Test whether Solvency or Equity provide additional explanations
reg  lnfeeexpord lnassets prepack preneg lnsales xyearfiled  shop solvency[pw=pweight], vce(robust)
reg  lnfeeexpord lnassets prepack preneg lnsales xyearfiled  shop equity [pw=pweight], vce(robust)

/// Evaluation using post-confirmation information
/// Table 3.4
///Evaluation Fee Calculator on next line
reg  lnfeeexpord lnroles [pw=pweight] , vce(robust)
outreg2 using table3_4.rtf, replace ///
	label ctitle("FeeExpOrd","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) ///
	title("Table 3.4","Determinants of Aggregate Fees and Expenses")  
outreg2, append: reg  lnfeeexpord lnroles lnassets lndaysin [pw=pweight], vce(robust)
outreg2, append: reg  lnfeeexpord lnroles lnassets lndaysin yearconfirmed lnemployees shop [pw=pweight], vce(robust)
outreg2, append: reg  lnfeeexpord lnroles lnassets lndaysin yearconfirmed lnemployees shop saleall [pw=pweight], vce(robust)

///  Table 3.?  How many firms work in Shop and 363 Sale cases?
bysort shop: oneway lnroles saleall, tab
bysort saleall: oneway lnroles shop, tab
oneway lnroles shop, tab
oneway lnroles saleall, tab

///  Negative results of the evaluation model
/// Chow tests of industry, judges and firms
foreach x in indu judges attyfirms fafirms {
	reg lnfeeexpord lnroles lnassets lndaysin yearconfirmed saleall lnemployees shop $`x'  [pw=pweight], vce(robust)	
	test $`x'
	}
foreach x of varlist lndocket feeexpcut refile {
	reg lnfeeexpord lnroles lnassets lndaysin yearconfirmed saleall lnemployees shop `x' [pw=pweight], vce(robust)
	}	
  	
	
/// Figure 3.1  Scale effect: what pct of the assets are paid in fees?  The last column will show that
reg  lnfeeexpord lnroles c.lnassets lndaysin yearconfirmed lnemployees saleall shop [pw=pweight], vce(robust)
capture drop c1-astscale
margins, at(lnassets=(4.6 5.52 6.2 6.9 7.82 8.5))
matrix b=r(b)'
matrix c=b
svmat c, names(c)
gen expb=(exp(c1))/1000000
gen expast=100 if _n==1
replace expast=250 if _n==2
replace expast=500 if _n==3
replace expast=1000 if _n==4
replace expast=2500 if _n==5
replace expast=5000 if _n==6
gen lnexpast = ln(expast)
gen astscale = expb/expast
clist c1-astscale in 1/6
/// Graph of scale effect
twoway (scatter astscale lnexpast)(connect astscale lnexpast, lpattern(solid) mcolor(black)),  /// 
	scheme(s1mono) legend(off) title("Figure 3.1.  Scale Effect in Fees and Expenses as a Percent of Assets", size(medlarge) span) /// 
	xlabel(4.6 "100" 5.52 "250" 6.2 "500" 6.9 "1,000" 7.82 "2,500" 8.5"5,000", labsize(medsmall)) ///
	ylabel(0 "0%" .01 "1%" .02 "2%" .03 "3%" .04 "4%" .05 "5%" .06 "6%", labsize(medsmall) angle(horizontal) grid) ///
	xtitle("Assets in Millions of Dollars" "(logged scale)") ytitle(Fees and Expenses as % of Assets) name(graph3_1, replace)
graph save Fig3_1.gph, replace
graph export Fig3_1.eps, replace
capture drop c1-astscale	

	
///  10-K Fee Study
///  Table 3.6  10-K fees
reg  lnproffees10k lnassets prepack preneg lnsales xyearfiled shop [pw=pwt10k], vce(robust)
outreg2 using table3_6.rtf, replace /// 
	label ctitle("ProfFees10K","(log)","Predictive") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2)  ///
	title("Table 3.6","Determinants of 10-K Aggregate Fees and Expenses") 
reg lnproffees10k lnassets prepackneg shop equity [pw=pwt10k], vce(robust)
outreg2 using table3_6.rtf, append ///
	label ctitle("ProfFees10K","(log)","Predictive") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2)  ///
	title("Table 3.6","Determinants of 10-K Aggregate Fees and Expenses") 
reg lnproffees10k lnroles lnassets lndaysin yearconfirmed lnemployees shop [pw=pwt10k], vce(robust)
outreg2 using table3_6.rtf, append /// 
	label ctitle("ProfFees10K","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2)  ///
	title("Table 3.6","Determinants of 10-K Aggregate Fees and Expenses") 
foreach x in indu judges attyfirms fafirms {
	reg  lnproffees10k lnroles lnassets lndaysin yearconfirmed lnemployees shop  $`x'  [pw=pwt10k], vce(robust)
	test $`x'
	}
reg  lnproffees10k lnassets lndaysin yearconfirmed transportation manufacturing services [pw=pwt10k], vce(robust)
outreg2 using table3_6.rtf, append /// 
	label ctitle("ProfFees10K","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2)  ///
	title("Table 3.6","Determinants of 10-K Aggregate Fees and Expenses") 

	
///  Table 3.7
reg  lnproffees10k  lnfeeexpord [pw=pwt10k], vce(robust)
outreg2 using table3_7.rtf, replace ///
	label ctitle("ProfFees10K","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) ///
	title("Table 3.7","Estimation of 10-K Aggregate Fees and Expenses","from Court File Data") 
reg  lnproffees10k lnfeeexpord lnassets lndaysin yearconfirmed transportation manufacturing services [pw=pwt10k], vce(robust)
outreg2 using table3_7.rtf, append ///
	label ctitle("ProfFees10K","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) ///
	title("Table 3.7","Estimation of 10-K Aggregate Fees and Expenses","from Court File Data") 
reg  lnproffees10k lnfeeexpord  lnsales equity  [pw=pwt10k], vce(robust)
outreg2 using table3_7.rtf, append ///
	label ctitle("ProfFees10K","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) ///
	title("Table 3.7","Estimation of 10-K Aggregate Fees and Expenses","from Court File Data") 
foreach x in indu judges attyfirms fafirms {
	reg lnproffees10k lnfeeexpord lnsales equity $`x' [pw=pwt10k], vce(robust)	
	test $`x'
	}
reg lnproffees10k lnfeeexpord lnsales equity walsh gonzalez lifland  [pw=pwt10k], vce(robust)
outreg2 using table3_7.rtf, append ///
	label ctitle("ProfFees10K","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) ///
	title("Table 3.7","Estimation of 10-K Aggregate Fees and Expenses","from Court File Data") 

/// Test whether Refile changes 10-K fees
reg lnproffees10k lnfeeexpord lnsales equity refile [pw=pwt10k], vce(robust)	
	
	log close
